﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

namespace SendRaw
{
    class Program
    {
        static void Main(string[] args)
        {
            string url = "http://db3.notify.live.net/throttledthirdparty/01.00/AAEQxeTQY0" +
                "T5R42SYg62O3a8AgAAAAADAQAAAAQUZm52OjIzOEQ2NDJDRkI5MEVFMEQ";

            string data = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" +
                "<ArrayOfStudent>" +
                  "<Student>" +
                    "<StudentNumber>123456</StudentNumber>" +
                    "<FirstName>Jane</FirstName>" +
                    "<LastName>Doe</LastName>" +
                  "</Student>" +
                  "<Student>" +
                    "<StudentNumber>987654</StudentNumber>" +
                    "<FirstName>Jane</FirstName>" +
                    "<LastName>Doe</LastName>" +
                  "</Student>" +
                "</ArrayOfStudent>";

            WebRequest request = WebRequest.Create(url);

            request.ContentType = "text/xml";
            request.Method = "POST";
            request.Headers.Add("X-NotificationClass", "3");

            byte[] bytes = Encoding.UTF8.GetBytes(data);

            using (Stream requestStream = request.GetRequestStream())
            {
                requestStream.Write(bytes, 0, bytes.Length);
                try
                {
                    HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                    string notificationStatus = response.Headers["X-NotificationStatus"];
                    string subscriptionStatus = response.Headers["X-SubscriptionStatus"];
                    string connectionStatus = response.Headers["X-DeviceConnectionStatus"];

                    Console.Write(String.Format("X-NotificationStatus:{0}\r\nX-" +
                        "SubscriptionStatus:{1}\r\nX-DeviceConnectionStatus:{2}",
                        notificationStatus, subscriptionStatus, connectionStatus));
                    Console.ReadKey();
                }
                catch (WebException ex)
                {
                    Console.Write("WebExeption occured with Statuscode:" +
                        ((HttpWebResponse)ex.Response).StatusCode.ToString());
                    Console.ReadKey();
                }
            }
        }
    }
}
